#version 430 core

layout (local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout(rgba32f, binding = 3) uniform image2D HitData;

layout(rgba32f, binding = 4) uniform image2D imgOutput;

uniform int TexView;
const float INF = 1.0/0.0;

vec4 AlphaBlend(vec4 color1,vec4 color2)
{
    return color1 * color1.a + color2 * (1.0 - color1.a);//(color1 * color1.a + color2 * color2.a * (1.0-color1.a))/(color1.a * color2.a * (1.0-color1.a));
}

void main() {
    ivec2 id = ivec2(gl_GlobalInvocationID.xy);

    vec4 PixDat = imageLoad(HitData,id);

    vec4 Final = vec4(0);
    float count = 0;

    if(!all(equal(PixDat.xyz,vec3(0,0,0))))
    {
        for (int X = -1; X < 2; X++)
        {
            for (int Y = -1; Y < 2; Y++)
            {
                ivec2 Pixel = ivec2(id.x+X,id.y+Y);

                vec4 CurDat = imageLoad(HitData,Pixel);

                if(all(equal(PixDat.xyz,CurDat.xyz))&& abs(PixDat.w - CurDat.w) < 1)
                {

                    Final += imageLoad(imgOutput, Pixel);

                    count++;
                }
            }
        }
        Final/=count;



        

        if(TexView == 0)
        {
            imageStore(imgOutput, id, Final);
        }
        else if(TexView == 1)
        {
            imageStore(imgOutput, id, imageLoad(HitData,id));
        }
        else if(TexView == 2)
        {
            imageStore(imgOutput, id, vec4(imageLoad(HitData,id).w)/50);
        }
    }
}