#version 430 core

precision highp float;
precision highp int;

const float INF = 1.0/0.0;
const float NINF = -1.0/0.0;
const float PI = 3.14159265359;

uint RngNumber = 13;

layout (local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout(rgba32f, binding = 0) uniform image2D imgOutput;
layout(rgba8, binding = 1) uniform image2D Skybox;

uniform mat4 _CameraToWorld;
uniform mat4 _CameraInverseProjection;

uniform vec3 Sunlight;

uniform int Width;
uniform int Height;

struct Ray
{
    vec3 origin;
    vec3 direction;
    vec3 energy;
};

Ray CreateRay(vec3 origin, vec3 direction)
{
    Ray ray;
    ray.origin = origin;
    ray.direction = direction;
    ray.energy = vec3(1,1,1);
    return ray;
}

struct RayHit
{
    vec3 position;
    float distance;
    vec3 normal;
    vec3 albedo;
    vec3 specular;
};

RayHit CreateRayHit()
{
    RayHit hit;
    hit.position = vec3(0.0f, 0.0f, 0.0f);
    hit.distance = INF;
    hit.normal = vec3(0.0f, 0.0f, 0.0f);
    hit.albedo = vec3(0.0f, 0.0f, 0.0f);
    hit.specular = vec3(0.0f, 0.0f, 0.0f);
    return hit;
}

Ray CreateCameraRay(vec2 uv)
{
    vec3 origin = (_CameraToWorld*vec4(0.0f,0.0f,0.0f,1.0f)).xyz;
    vec3 direction = (_CameraInverseProjection*vec4(uv,0.0f,1.0f)).xyz;
    direction = (_CameraToWorld*vec4(direction,0.0f)).xyz;
    direction = normalize(direction);
    return CreateRay(origin,direction);
}

//! Ray traversal

int GetIndex(vec3 WorldCoord)
{
    float Index = WorldCoord.z + WorldCoord.y * GridSize + WorldCoord.x * GridSize * GridSize;
    return int(Index);
}

vec3 FindCurrentVoxel(vec3 OriginOfRay)
{
    float VoxSpacing = 0.1f;//1/(float)VoxelSize;

    float x = floor(OriginOfRay.x);
    float y = floor(OriginOfRay.y);
    float z = floor(OriginOfRay.z);
    return vec3(x,y,z);
}

float CalculateTime(float UnitOriginAxis, float RayDirAxis)
{
    if(RayDirAxis > 0)
    {
        return ((1.00001f-UnitOriginAxis)/RayDirAxis);
    }
    else if(RayDirAxis <= 0)
    {

        return ((-0.00001f-UnitOriginAxis)/RayDirAxis);
    }
}

float GetT(vec3 VoxelOrigin, vec3 OriginRay, vec3 RayDir)
{
    vec3 UnitOrigin = OriginRay - VoxelOrigin;
    
    float Tx = CalculateTime(UnitOrigin.x,RayDir.x);
    float Ty = CalculateTime(UnitOrigin.y,RayDir.y);
    float Tz = CalculateTime(UnitOrigin.z,RayDir.z);

    float Comp1 = min(Tx,Ty);
    float Comp = min(Comp1,Tz);

    return Comp;
}

//! Hemispherestuff



void IntersectCube(Ray ray, inout RayHit idealHit,vec3 Spec,vec3 Alb,vec4 position)
{
    vec3 cubeMin = position.xyz - position.w; // Calculate minimum corner of the cube
    vec3 cubeMax = position.xyz + position.w; // Calculate maximum corner of the cube

    vec3 tMin = (cubeMin - ray.origin) / ray.direction;
    vec3 tMax = (cubeMax - ray.origin) / ray.direction;

    vec3 t1 = min(tMin, tMax);
    vec3 t2 = max(tMin, tMax);

    float tNear = max(max(t1.x, t1.y), t1.z);
    float tFar = min(min(t2.x, t2.y), t2.z);

    if (tNear <= tFar && tFar > 0 && tNear < idealHit.distance)
    {
        idealHit.distance = tNear;
        idealHit.position = ray.origin + tNear * ray.direction;

        // Determine which face of the cube was hit
        vec3 hitNormal;
        if (t1.x > t1.y && t1.x > t1.z)
            hitNormal = vec3(sign(ray.direction.x), 0, 0);
        else if (t1.y > t1.z)
            hitNormal = vec3(0, sign(ray.direction.y), 0);
        else
            hitNormal = vec3(0, 0, sign(ray.direction.z));

        idealHit.normal = -hitNormal;
        idealHit.specular = Spec;
        idealHit.albedo = Alb;
    }
}

void main() 
{
    ivec2 id = ivec2(gl_GlobalInvocationID);

    vec4 pixel =vec4(1.0);

    vec2 uv = vec2((id.xy+vec2(.5f,.5f))/vec2(Width,Height)*2.0f-1.0f);

    Ray ray = CreateCameraRay(uv);
    
    vec3 Result = vec3(1);

    RayHit Hit;

    float theta = acos(ray.direction.y) / -3.141592653589793;
    float phi = atan(ray.direction.x, -ray.direction.z) / -3.141592653589793 * 0.5;
    vec4 Pix2 = imageLoad(Skybox, id);




    pixel = vec4(ray.direction * 0.5f + 0.5f,1);
    imageStore(imgOutput,id,pixel+Pix2);
}